IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_FECHA_CRED_SOMA_FECHAMENTO]'))
DROP VIEW [dbo].[V_FECHA_CRED_SOMA_FECHAMENTO]
GO

CREATE VIEW [dbo].[V_FECHA_CRED_SOMA_FECHAMENTO] WITH ENCRYPTION
AS
SELECT 
	DISTINCT 
	FECHA.CD_CTR_FECHA,
	RC_CLI.CD_CLI,
	RC_CLI.RZ_CLI,
	FECHA_DEB.CD_FILIAL,
	RC_DEB.NR_DP,
	FECHA.VLR_FECHA,
	FECHA.DT_CAD,
	FECHA.DT_VENCTO,
	FECHA_DEB.CD_RC_DEB,
	RC_DEB.NR_FATURA,
	CASE WHEN RC_DEB.STS_DP= 0 THEN
		'0 - Dup.Nao Liquidada'
		WHEN RC_DEB.STS_DP= 1 THEN
			'1 - Liquidada Total'
		WHEN RC_DEB.STS_DP=2 THEN
			'2 - Liquidada Parcialmente'
		WHEN RC_DEB.STS_DP=3 THEN
			'3 - Cancelada'
		WHEN RC_DEB.STS_DP=4 THEN
			'4 - Renegociada'
		WHEN RC_DEB.STS_DP=5 THEN
			'5 - Aguard.Ret.Banco'
	ELSE
		'6 - Dup. Credito Estornado'
	END STS_DP
FROM  
	RC_CREDIARIO_FECHA FECHA
	INNER JOIN RC_CLI ON  
	FECHA.CD_EMP = RC_CLI.CD_EMP AND 
	FECHA.CD_CLI = RC_CLI.CD_CLI
	
	INNER JOIN RC_CREDIARIO_FECHA_RC_DEB FECHA_DEB ON  
	FECHA.CD_EMP       = FECHA_DEB.CD_EMP AND 
	FECHA.CD_CTR_FECHA = FECHA_DEB.CD_CTR_FECHA
	
	LEFT OUTER JOIN RC_CRED ON  
	FECHA_DEB.CD_EMP    = RC_CRED.CD_EMP AND 
	FECHA_DEB.CD_FILIAL = RC_CRED.CD_FILIAL AND 
	FECHA_DEB.CD_RC_DEB = RC_CRED.CD_RC_DEB
	
	LEFT OUTER JOIN RC_CREDIARIO_FECHA_RC_CRED FECHA_CRED ON 
	FECHA.CD_CTR_FECHA = FECHA_CRED.CD_CTR_FECHA
	
	INNER JOIN RC_DEB ON  
	FECHA_DEB.CD_EMP    = RC_DEB.CD_EMP AND 
	FECHA_DEB.CD_FILIAL = RC_DEB.CD_FILIAL AND 
	FECHA_DEB.CD_RC_DEB = RC_DEB.CD_RC_DEB

	LEFT JOIN RC_CREDIARIO_PARC_RC_CREDIARIO_FECHA F ON
	F.CD_CTR_FECHA=FECHA.CD_CTR_FECHA

GO